/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.anim;

import java.util.List;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.format.rco.object.BaseObject;
import jpcsp.format.rco.object.BasePositionObject;
import jpcsp.format.rco.type.ObjectType;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXObject;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import jpcsp.scheduler.Scheduler;

public class BaseAnim
extends BaseObject {
    protected long doPlayReference(BasePositionObject object) {
        return 0L;
    }

    protected long doPlayReference(BaseNativeObject object) {
        if (object instanceof BasePositionObject) {
            return this.doPlayReference((BasePositionObject)object);
        }
        return 0L;
    }

    private long doPlayReference(VSMXBaseObject object) {
        if (object instanceof VSMXNativeObject) {
            return this.doPlayReference(((VSMXNativeObject)object).getObject());
        }
        return 0L;
    }

    protected long doPlayReference(ObjectType ref) {
        VSMXBaseObject children;
        List<String> names;
        BasePositionObject positionObject = ref.getPositionObject();
        if (positionObject == null) {
            return 0L;
        }
        VSMXObject object = positionObject.getObject();
        long delay = this.doPlayReference(object);
        if (((VSMXBaseObject)object).hasPropertyValue("children") && (names = (children = ((VSMXBaseObject)object).getPropertyValue("children")).getPropertyNames()) != null) {
            for (String name : names) {
                VSMXBaseObject child = children.getPropertyValue(name);
                delay = Math.max(delay, this.doPlayReference(child));
            }
        }
        return delay;
    }

    protected long doPlay(VSMXBaseObject object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("BaseAnim play on %s", object));
        }
        return 0L;
    }

    public void play(VSMXBaseObject thisObject, VSMXBaseObject object) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("BaseAnim.play %s, %s", thisObject, object));
        }
        if (thisObject.hasPropertyValue("children")) {
            VSMXBaseObject children = thisObject.getPropertyValue("children");
            List<String> names = children.getPropertyNames();
            BaseAnim[] baseAnims = new BaseAnim[names.size() + 1];
            int numberBaseAnims = 0;
            baseAnims[numberBaseAnims++] = this;
            for (String name : names) {
                BaseNativeObject baseNativeObject;
                VSMXBaseObject child = children.getPropertyValue(name);
                if (!(child instanceof VSMXNativeObject) || !((baseNativeObject = ((VSMXNativeObject)child).getObject()) instanceof BaseAnim)) continue;
                baseAnims[numberBaseAnims++] = (BaseAnim)baseNativeObject;
            }
            if (numberBaseAnims > 0) {
                BaseAnim.getScheduler().addAction(new PlayAnimAction(baseAnims, 0, numberBaseAnims, object));
            }
        }
    }

    private static class PlayAnimAction
    implements IAction {
        private BaseAnim[] children;
        private int index;
        private int length;
        private VSMXBaseObject object;

        public PlayAnimAction(BaseAnim[] children, int index, int length, VSMXBaseObject object) {
            this.children = children;
            this.index = index;
            this.length = length;
            this.object = object;
        }

        @Override
        public void execute() {
            while (this.index < this.length) {
                long delay;
                if ((delay = this.children[this.index++].doPlay(this.object)) <= 0L) continue;
                BaseAnim.getScheduler().addAction(Scheduler.getNow() + delay * 1000L, this);
                return;
            }
        }
    }
}

